
from django import forms
from django.test import TestCase

class FormFieldAttrstTestCase(TestCase):
    
    def test_char_field_attrs_are_present(self):
        f = forms.CharField(min_length=10, max_length=20)
        self.assertEquals(f.min_length, 10)
        self.assertEquals(f.max_length, 20)
        
    def test_integer_field_attrs_are_present(self):
        f = forms.IntegerField(min_value=10, max_value=20)
        self.assertEquals(f.min_value, 10)
        self.assertEquals(f.max_value, 20)
        
    def test_float_field_attrs_are_present(self):
        f = forms.FloatField(min_value=10, max_value=20)
        self.assertEquals(f.min_value, 10)
        self.assertEquals(f.max_value, 20)
        
    def test_decimal_field_attrs_are_present(self):
        f = forms.DecimalField(min_value=10, max_value=20, max_digits=8, decimal_places=4)
        self.assertEquals(f.max_digits, 8)
        self.assertEquals(f.decimal_places, 4)
        self.assertEquals(f.min_value, 10)
        self.assertEquals(f.max_value, 20)
        
    def test_char_field_min_length_and_max_length_can_be_set(self):
        f = forms.CharField()
        f.min_length = 2
        f.max_length = 2
        self.assertRaises(forms.ValidationError, f.clean, "x")
        self.assertRaises(forms.ValidationError, f.clean, "xxx")
        
    def test_integer_field_min_value_and_max_value_can_be_set(self):
        f = forms.IntegerField()
        f.min_value = 2
        f.max_value = 2
        self.assertRaises(forms.ValidationError, f.clean, "1")
        self.assertRaises(forms.ValidationError, f.clean, "3")
        
    def test_float_field_min_value_and_max_value_can_be_set(self):
        f = forms.FloatField()
        f.min_value = 2
        f.max_value = 2
        self.assertRaises(forms.ValidationError, f.clean, "1")
        self.assertRaises(forms.ValidationError, f.clean, "3")
        
    def test_decimal_field_min_value_and_max_value_can_be_set(self):
        f = forms.DecimalField()
        f.min_value = 2
        f.max_value = 2
        self.assertRaises(forms.ValidationError, f.clean, "1")
        self.assertRaises(forms.ValidationError, f.clean, "3")
        
    def test_decimal_field_max_digits_and_decimal_places_can_be_set(self):
        f = forms.DecimalField()
        f.max_digits = 2
        f.decimal_places = 1
        self.assertRaises(forms.ValidationError, f.clean, "111")
        self.assertRaises(forms.ValidationError, f.clean, "0.11")
        