
def is_assigned_to_the_second_db(obj):
    from split_test.test_app.models import TheSecondDBModel
    try:
        return isinstance(obj, TheSecondDBModel) or issubclass(obj, TheSecondDBModel)
    except TypeError: 
        return False   
    
class DBRouter(object):
    
    def db_for_read(self, model, **hints):
        if is_assigned_to_the_second_db(model):
            print model
        return 'default'

    def db_for_write(self, model, **hints):
        if is_assigned_to_the_second_db(model):
            return 'second'
        return 'default'

    def allow_relation(self, obj1, obj2, **hints):
        if is_assigned_to_the_second_db(obj1) != is_assigned_to_the_second_db(obj2): 
            return False
        return True

    def allow_syncdb(self, db, model):
        if db == 'default':
            return not is_assigned_to_the_second_db(model)
        else:
            return is_assigned_to_the_second_db(model)
