import datetime, unittest
from django.test.client import Client
from models import Article


class DateBasedTestCase(unittest.TestCase):
    """Unit tests for date-based generic views."""

    def setUp(self):
        self.client = Client()
        # Add three articles published today
        now = datetime.datetime.now()
        for i in range(3):
            article = Article(title='Article %d' % (i+1), pub_date=now)
            article.save()
        # Add an earlier article
        date = datetime.date(2007, 1, 1)
        article = Article(title='Article 4', pub_date=date)
        article.save()
        # Add a later article
        future = now.replace(year=now.year+1)
        article = Article(title='Article 5', pub_date=future)

    def tearDown(self):
        Article.objects.all().delete()

    def testArchiveToday(self):
        response = self.client.get('/generic_views/today/')
        self.failUnlessEqual(response.status_code, 200)
        self.failUnlessEqual(len(response.context['object_list']), 3)

    def testArchiveDayNumericMonth(self):
        response = self.client.get('/generic_views/day_num_month/2007/1/1/')
        self.failUnlessEqual(response.status_code, 200)
        self.failUnlessEqual(len(response.context['object_list']), 1)

    def testArchiveDayAbbrevMonth(self):
        response = self.client.get('/generic_views/day_abbrev_month/2007/jan/1/')
        self.failUnlessEqual(response.status_code, 200)
        self.failUnlessEqual(len(response.context['object_list']), 1)
