# -*- coding: utf-8 -*-


"""
PY-specific Form helpers.
"""

from django.forms import ValidationError
from django.forms.fields import RegexField, CharField, Select, EMPTY_VALUES
#from django.utils.encoding import smart_unicode
#from django.utils.translation import ugettext_lazy as _

class PyDepartmentSelect(Select):
    """
    A Select widget with a list of Paraguayan departments as choices.
    """
    def __init__(self, attrs=None):
        from py_departments import DEPARTMENT_CHOICES
        super(PyDepartmentSelect, self).__init__(attrs, choices=DEPARTMENT_CHOICES)


class PyNumeratedDepartmentSelect(Select):
    """
    A Select widget with a roman numerated list of Paraguayan departments as choices.
    """
    def __init__(self, attrs=None):
        from py_departments import DEPARTMENT_ROMAN_CHOICES
        super(PyNumeratedDepartmentSelect, self).__init__(attrs, choices=DEPARTMENT_ROMAN_CHOICES)


