from django.test import TestCase
from models import Person, OutfitItem, Fashionista

class AdminTest(TestCase):
    fixtures = ['initial.json']

    def setUp(self):
        Person(firstname='test person').save()
        OutfitItem(name='something').save()
        self.client.login(username='super', password='secret')

    def tearDown(self):
        self.client.logout()

    def test_inline_primary(self):
        #Imelda likes shoes, but can't cary her own bags.
        data = {
            'shoppingweakness_set-TOTAL_FORMS': 1,
            'shoppingweakness_set-INITIAL_FORMS': 0,
            'shoppingweakness_set-MAX_NUM_FORMS': 0,
            '_save': u'Save',
            'person': 1,
            'max_weight': 0,
            'shoppingweakness_set-0-item': 1,
            'shoppingweakness_set-0-severeness': 100
        }
        response = self.client.post('/admin/primary_key_inline/fashionista/add/', data)
        errors = response.context['errors']
        for error in errors:
            self.assertContains(response, errors)
        self.assertEqual(len(Fashionista.objects.filter(person__firstname='Imelda')), 1)
