"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.test import TestCase, Client
from models import Fashionista

class AdminTest(TestCase):
    fixtures = ['initial.json']
    
    def setUp(self):
        self.client.login(username='super', password='secret')
    
    def test_inline_primary(self):
        #Imelda likes shoes, but can't cary her own bags.
        data = {
            'shoppingweakness_set-TOTAL_FORMS': 1,
            'shoppingweakness_set-INITIAL_FORMS': 0,
            'shoppingweakness_set-MAX_NUM_FORMS': 0,
            '_save': u'Save',
            'person': 1,
            'max_weight': 0,
            'shoppingweakness_set-0-item': 1,
            'shoppingweakness_set-0-severeness': 100
        }
        response = self.client.post('/admin/primary_key_inline/fashionista/add/', data)
        self.assertEqual(response.status_code, 302) #redirects somewhere
        #and created a fashionista
        self.assertEqual(len(Fashionista.objects.filter(person__firstname='Imelda')), 1)
