from django.db import models
from django.contrib import admin

class Person(models.Model):
    firstname = models.CharField(max_length=15)
    def __str__(self):
        return self.firstname

class OutfitItem(models.Model):
    name = models.CharField(max_length=15)
    def __str__(self):
        return self.name

class Fashionista(models.Model):
    person = models.OneToOneField(Person, primary_key=True)
    max_weight = models.PositiveSmallIntegerField(help_text='Maximum weight of shopping bag in kg Fashionista can cary.')
    weaknesses = models.ManyToManyField(OutfitItem, through='ShoppingWeakness', blank=True)
    def __str__(self):
        return str(self.person)

class ShoppingWeakness(models.Model):
    fashionista = models.ForeignKey(Fashionista)
    item = models.ForeignKey(OutfitItem)
    severeness = models.PositiveSmallIntegerField(help_text='Severeness on scale of 1 to 100.')

#Admin

class InlineWeakness(admin.TabularInline):
    model = ShoppingWeakness

class FashionistaAdmin(admin.ModelAdmin):
    inlines = [InlineWeakness]

admin.site.register(Person)
admin.site.register(OutfitItem)
admin.site.register(Fashionista, FashionistaAdmin)
