// require('prototype.js')
// uses document.getElementsByClassName(className, parentElement)

var Tabset = Class.create();
Tabset.prototype = {
  initialize: function(container, tabs, content_class, tab_class, tab_state_class){
    this.tab_class = tab_class? tab_class:'TabItem'; 
    this.content_class = content_class? content_class:'TabContent'; 
    this.tabs = tabs? tabs:'TabList'; // id for div containing tabs
    this.container = container? container:'TabContainer'; // id 
    this.tab_state_class = tab_state_class? tab_state_class: 'Tab';
    //e.g. tab_state_class = Tab => TabOn, TabOff specifies On/Off class
  },
  activate: function(elm){
    // e.g. onclick(){TABS.activate(this)}
    tgt = $(elm.getAttribute('target')); // elm.target works for IE & Opera but not for FF
    if (!tgt) return;
    var i, contents;
    contents = document.getElementsByClassName(this.content_class, this.container);
    if(contents.length > 0){
      // hide everything first
      for(i = 0; i < contents.length; i++){
	contents[i].style.display = "none";
      }
      // show target
      tgt.style.display = "block";
      // toggle tabs
      tabs = document.getElementsByClassName(this.tab_class, this.tabs);
      if(tabs.length > 0){
	for(i = 0; i < tabs.length; i++){
	  Element.removeClassName(tabs[i], this.tab_state_class+"On");
	  Element.addClassName(tabs[i], this.tab_state_class+"Off");
	}
      }
      Element.removeClassName(tabs[i], this.tab_state_class+"On");
      Element.addClassName(elm,this.tab_state_class+"On");
    }
  }
}

