from django.template import Library, Node, TemplateSyntaxError, Template
from django.template.loader import get_template
from django.conf import settings

#from rexec import RExec


from helpers.url import *	
from helpers.javascript import *	
from helpers.tag import *	
from helpers.prototype import *	
from helpers.scriptaculous import *	
from helpers.form_tag import *	
from helpers.text import *	
from helpers.form_options import *	
from helpers.date import *	
from helpers.number import *	
helpers = ["simple_format",
           "sortable_element",
           "time_ago_in_words",
           "link_to",
           "reset_cycle",
           "number_to_phone",
           "button_to_function",
           "password_field",
           "submit_to_remote",
           "number_to_human_size",
           "link_to_unless",
           "hidden_field",
           "word_wrap",
           "link_to_unless_current",
           "update_element_function",
           "start_form",
           "link_to_if",
           "number_with_precision",
           "select",
           "distance_of_time_in_words_to_now",
           "auto_link",
           "parallel_effects",
           "options_for_select_from_dicts",
           "form",
           "drop_receiving_element",
           "form_remote_tag",
           "strip_links",
           "observe_field",
           "draggable_element",
           "submit",
           "end_form",
           "text_area",
           "evaluate_remote_response",
           "button_to",
           "number_to_currency",
           "check_box",
           "options_for_select_from_objects",
           "remote_function",
           "camelize",
           "excerpt",
           "options_for_select",
           "file_field",
           "periodically_call_remote",
           "text_field",
           "distance_of_time_in_words",
           "link_to_remote",
           "radio_button",
           "cycle",
           "content_tag",
           "url",
           "javascript_tag",
           "current_page",
           "escape_javascript",
           "number_with_delimiter",
           "visual_effect",
           "cdata_section",
           "tag",
           "number_to_percentage",
           "truncate",
           "highlight",
           "observe_form",
           "link_to_function"]


register = Library()

#@register.tag
def rails(parser, token):
    """
    Ajax helper tags ported from RoR. 

    Usage :
        {% railshelper_name (arg1,arg2,kwarg1=3,...) %}

        or
        
        {% railshelper_name %}
        arg1,arg2,
        arg3,
        kwarg1=value1,
        kwarg2=value2,
        ...
        {% endrailshelper_name %}
        
    """
    bits = token.contents.split()
    helpername = bits[0]
    if len(bits) == 1:
        # parameter supplied by block 
        nodelist = parser.parse(('end%s' % helpername,))
        parser.delete_first_token()
        return RailsHelperNode(helpername, nodelist)
    # parameter supplied by function argument format
    param = ' '.join(bits[1:]).strip()
    if param[0]=='(':
        param = param[1:]
    if param[-1]==')':
        param = param[:-1]
    return RailsHelperNode(helpername, Template(param))

for helper in helpers:
    register.tag(helper, rails)

def test(*args, **kws):
    return "args=%s, kws=%s" % (args, kws)

register.tag('test',rails)

class RailsHelperNode(Node):
    def __init__(self, func_name, nodelist):
        self.func_name = func_name
        self.node_list = nodelist

    def render(self, context):
        if not getattr(self.__module__, self.func_name, 'None'):
            return ''
        param = self.node_list.render(context)
        def argparser(*args, **kws):
            return args, kws
        try:
            exec("args, kws = argparser("+param+")")
        except :
            if settings.DEBUG:
                return "[RailsHelperNode error parsing arguments.]"
            else:
                return ''
        try:
            mod = __import__(self.__module__, '', '', [''])
            if not hasattr(mod, self.func_name):
                if settings.DEBUG:
                    return "no %s in railshelper" % self.func_name
                else:
                    return ''
            return getattr(mod, self.func_name)(*args, **kws)
        except:
            if settings.DEBUG:
                return "[RailsHelperNode error executing function.]"
            else:
                return '' 



