// require('prototype.js')

var Selection = Class.create();
Selection.prototype = {
  initialize: function(items, isCollection) {
    this.items = [];
    this.selection = [];
    this.lastSelected = null;
    this.allowImplicit = true;// if true, grow selection will start from 0th item when nothing is selected
    this.length= 0; // number of *selected* items
    if(items) {
      if(isCollection) {
	this.setItemsCollection(items);
      } else {
	this.setItems(items);
      }
    }
  },
  // event handlers
  onSelect: function(item){},
  onDeselect: function(item){},
  onSelectChange: function(items){},
  
  isSelectable: function(item) {
    // user-customizable, will filter items through this
    return true;
  },
  setItems: function(/* ... */) {
    this.clearItems();
    this.addItems.call(this, arguments);
  },
  // this is in case you have an active collection array-like object
  // (i.e. getElementsByTagName collection) that manages its own order
  // and item list
  setItemsCollection: function(collection) {
    this.clearItems();
    this.items = collection;
  },
  addItems: function(/* ... */) {
    var args = $A(arguments).flatten();
    for(var i = 0; i < args.length; i++) {
      this.items.push(args[i]);
    }
  },
  //_find: function(item){return $A(this.items).indexOf(item);},
  //_findInSelection: function(item){return $A(this.selection).indexOf(item);};
  addItemsAt: function(item, before /* ... */) {
    if(this.items.length == 0) { // work for empy case
      return this.addItems($A(arguments).slice(2));
    }
    if(!this.isItem(item)) {
      item = this.items[item];
    }
    if(!item) { throw new Error("addItemsAt: item doesn't exist"); }
    var idx = $A(this.items).indexOf(item);
    if(idx > 0 && before) { idx--; }
    for(var i = 2; i < arguments.length; i++) {
      if(!this.isItem(arguments[i])) {
	this.items.splice(idx++, 0, arguments[i]);
      }
    }
  },
  removeItem: function(item) {
    // remove item
    var idx = $A(this.items).indexOf(item);
    if(idx > -1) {
      this.items.splice(i, 1);
    }
    // remove from selection
    // FIXME: do we call deselect? I don't think so because this isn't how
    // you usually want to deselect an item. For example, if you deleted an
    // item, you don't really want to deselect it -- you want it gone. -DS
    idx = $A(this.selection).indexOf(item);
    if(idx > -1) {
      this.selection.splice(i, 1);
    }
  },
  clearItems: function() {
    this.items = [];
    this.deselectAll();
  },
  isItem: function(item) {
    return $A(this.items).indexOf(item) > -1;
  },
  isSelected: function(item) {
    return $A(this.selection).indexOf(item) > -1;
  },
  /**
   * allows you to filter item in or out of the selection
   * depending on the current selection and action to be taken
   **/
  selectFilter: function(item, selection, add, grow) {
    return true;
  },

  /**
   * update -- manages selections, most selecting should be done here
   *  item => item which may be added/grown to/only selected/deselected
   *  add => behaves like ctrl in windows selection world
   *  grow => behaves like shift
   *  noToggle => if true, don't toggle selection on item
   **/
  update: function(item, add, grow, noToggle) {
    if(!this.isItem(item)) { return false; }
    if(grow) {
      if(!this.isSelected(item) && this.selectFilter(item, this.selection, false, true)) {
	this.grow(item);
	this.lastSelected = item;
      }
    } else if(add) {
      if(this.selectFilter(item, this.selection, true, false)) {
	if(noToggle) {
	  if(this.select(item)) {
	    this.lastSelected = item;
	  }
	} else if(this.toggleSelected(item)) {
	  this.lastSelected = item;
	}
      }
    } else {
      this.deselectAll();
      this.select(item);
    }
    this.length = this.selection.length;
  },
  /**
   * Grow a selection.
   *  toItem => which item to grow selection to
   *  fromItem => which item to start the growth from (it won't be selected)
   *
   * Any items in (fromItem, lastSelected] that aren't part of
   * (fromItem, toItem] will be deselected
   **/
  grow: function(toItem) {
    fromItem = this.lastSelected;
    if(!fromItem && this.allowImplicit) {
      fromItem = this.items[0];
      this.select(fromItem, true);
      alert('fromItem set to 0');
    }
    if(!toItem || !fromItem) { return false; }
    var fromIdx = $A(this.items).indexOf(fromItem);
    // get items to deselect (fromItem, lastSelected]
    // add selection (fromItem, toItem]
    var toIdx = $A(this.items).indexOf(toItem);
    var start = fromIdx < toIdx ? fromIdx : toIdx;
    var end   = toIdx <= fromIdx ? fromIdx : toIdx;
    var range = $R(start, end);
    if (end-start>0){
      iter = function(v,i){
	var item = this.items[v];
	if(this.selectFilter(item, this.selection, false, true)){
	  this.select(item,true);
	}
      }
      range.each(iter.bind(this));
      this.lastSelected = toItem;
      this.onSelectChange(this.selection);
    }
  },
  /**
   * Grow selection upwards one item from lastSelected
   **/
  growUp: function() {
    var idx = $A(this.items).indexOf(this.lastSelected) - 1;
    while(idx >= 0) {
      if(this.selectFilter(this.items[idx], this.selection, false, true)) {
	this.grow(this.items[idx]);
	break;
      }
      idx--;
    }
  },
  /**
   * Grow selection downwards one item from lastSelected
   **/
  growDown: function() {
    var idx = $A(this.items).indexOf(this.lastSelected);
    if(idx < 0 && this.allowImplicit) {
      this.select(this.items[0]);
      idx = 0;
    }
    idx++;
    while(idx > 0 && idx < this.items.length) {
      if(this.selectFilter(this.items[idx], this.selection, false, true)) {
	this.grow(this.items[idx]);
	break;
      }
      idx++;
    }
  },
  toggleSelected: function(item, noPivot) {
    if(this.isItem(item)) {
      if(this.select(item, noPivot)) { return 1; }
      if(this.deselect(item)) { return -1; }
    }
    return 0;
  },
  select: function(item,notrigger) {
    var donttrigger = notrigger==undefined?false:true;
    if(this.isItem(item) && !this.isSelected(item)
       && this.isSelectable(item)) {
      this.selection.push(item);
      this.lastSelected = item;
      this.onSelect(item);
      if (donttrigger) return true;
      this.onSelectChange(this.selection);
      return true;
    }
    return false;
  },
  deselect: function(item) {
    var idx = $A(this.selection).indexOf(item);
    if(idx > -1) {
      this.selection.splice(idx, 1);
      this.onDeselect(item);
      //this.onSelectChange(this.selection);
      if(item == this.lastSelected) {
	this.lastSelected = null;
      }
      return true;
    }
    return false;
  },
  selectAll: function() {
    for(var i = 0; i < this.items.length; i++) {
      this.select(this.items[i]);
    }
  },
  deselectAll: function() {
    while(this.selection && this.selection.length) {
      this.deselect(this.selection[0]);
    }
  },
  selectNext: function() {
    var idx = $A(this.items).indexOf(this.lastSelected);
    while(idx > -1 && ++idx < this.items.length) {
      if(this.isSelectable(this.items[idx])) {
	this.deselectAll();
	this.select(this.items[idx]);
	return true;
      }
    }
    return false;
  },
  selectPrevious: function() {
    //debugger;
    var idx = $A(this.items).indexOf(this.lastSelected);
    while(idx-- > 0) {
      if(this.isSelectable(this.items[idx])) {
	this.deselectAll();
	this.select(this.items[idx]);
	return true;
      }
    }
    return false;
  },
  selectFirst: function() {
    return this.select(this.items[0]);
  },
  selectLast: function() {
    return this.select(this.items[this.items.length-1]);
  },
  sorted: function() {
    func =  function(a, b) {
      var A = $A(this.items).indexOf(a);
      var B = $A(this.items).indexOf(b);
      if(A > B) {
	return 1;
      } else if(A < B) {
	return -1;
      } else {
	return 0;
      }
    };
    return $A(this.selection).sort(func.bind(this));
  },
  // remove any items from the selection that are no longer in this.items
  updateSelected: function() {
    for(var i = 0; i < this.selection.length; i++) {
      if($A(this.items).indexOf(this.selection[i]) < 0) {
	var removed = this.selection.splice(i, 1);
      }
    }
  }
};



DomSelector = Class.create();
DomSelector.prototype = {
  initialize: function(id,tag,multiple,clickCallback,changeCallback,selectColor,mouseoverColor1,mouseoverColor2){
    this.selection = new Selection();
    this.multiple = multiple? multiple:false;
    this.targetId = id?id:'';
    this.targetTag = tag?tag:'tr'; // default table row
    this.selectColor = selectColor? selectColor: 'red';
    this.mouseoverColor1 = mouseoverColor1? mouseoverColor1: '#d5d5d5';
    this.mouseoverColor2 = mouseoverColor2? mouseoverColor2: '#7f7';
    this.clickCallback = clickCallback;
    this.changeCallback = changeCallback;
    this.setup();
    this.selection.onSelect = this.selectItem.bind(this);
    this.selection.onDeselect= this.deselectItem.bind(this);
    this.selection.onSelectChange = this.onChange.bind(this);
  },
  setup: function(id){
    this.targetId = id?id:this.targetId;
    node = $(this.targetId);
    disableHtmlSelection(node);
    if (node){
      targets = node.getElementsByTagName(this.targetTag);
      this.selection.setItemsCollection(targets);
      for (var i=0; i<targets.length; i++){
	Event.observe(targets[i], 'click', this.clickHandler.bindAsEventListener(this));
	Event.observe(targets[i], 'mouseover', this.mouseoverHandler.bindAsEventListener(this));
	Event.observe(targets[i], 'mouseout', this.mouseoutHandler.bindAsEventListener(this));
      }
    }
  },
  clickHandler: function(evt){
    obj = Event.findElement(evt, this.targetTag);
    sel = this.selection;
    if (this.multiple){
      if (evt.shiftKey){
	sel.update(obj, false, true, false);
      }else if (evt.ctrlKey){
	sel.update(obj, true, false, false);
      }else{
	sel.update(obj, false, false, false);
      }
    }else{
      sel.update(obj, false, false, false);
    }
    if (this.clickCallback){
      this.clickCallback(obj);
    }
  },
  onChange: function(obj){
    if(this.changeCallback){
      this.changeCallback(obj)
    }
  }, 
  mouseoverHandler: function(evt){
    obj = Event.findElement(evt, this.targetTag);
    if (obj.style.backgroundColor){
      if ( obj.savedColor && (obj.style.backgroundColor != obj.savedColor)){
	obj.savedColor = obj.style.backgroundColor;
      }
    }
    if (obj.selected==null | !obj.selected){
      obj.style.backgroundColor=this.mouseoverColor1;
      window.status = 'mouseover 1';
      return true;
    }else{
      window.status = 'mouseover 2';
      obj.style.backgroundColor=this.mouseoverColor2;
      return true;
    }
  },
  mouseoutHandler: function(evt){
    obj = Event.findElement(evt, this.targetTag);
    if (obj.selected==null | !obj.selected){
      if (obj.savedColor == obj.style.backgroundColor){
	alert('BUG! mouseout '+obj.savedColor+' '+obj.style.backgroundColor);
      }
      if (obj.savedColor){
	obj.style.backgroundColor= obj.savedColor;
      }else{
	obj.style.backgroundColor= 'white';
      }
    }else{
      obj.style.backgroundColor= this.selectColor;
    }
  },
  selectItem: function(item){
    item.style.backgroundColor=this.selectColor;
    item.selected=true;
    window.status = 'selectItem';
    return true;
  },
  deselectItem: function(item){
    if (item.savedColor){
      alert('item.savedColor='+item.savedColor);
      item.style.backgroundColor=item.savedColor;
    }else{
      item.style.backgroundColor='white';
    }
    item.selected=false;
  }
};


disableHtmlSelection = function(element){
  element = $(element);
  element.style.MozUserSelect = "none";
  element.style.KhtmlUserSelect = "none";
  element.unselectable = "on";
}
