from django.contrib import admin
from parliament.models import Alert, Twfyuser, ApiKey, Member, Hansard, Moffice, Epobject, Anonvotes, Indexbatch, Uservotes, SearchQueryLog, Chamber, Person, Expense

class MofficeInline(admin.TabularInline):
        model = Moffice
        exclude = ('moffice_id',)
        
class ExpenseInline(admin.TabularInline):
        model = Expense
        
class PersonAdmin(admin.ModelAdmin):
        ordering = ('name',)
        inlines = [
                MofficeInline,
                ExpenseInline,
        ]

admin.site.register(Person,PersonAdmin)

