from django.db import models

class Animal(models.Model):

    name = models.CharField(max_length=100)

    class Meta:
        abstract = False

    def say_hello(self):
        pass


class Dog(Animal):

    def say_hello(self):
        print '%s says woof' % self.name


class Cat(Animal):

    def say_hello(self):
        print '%s says meaow' % self.name


__test__ = {'API_TESTS': """

>>> dog = Dog(name='Pluto')
>>> dog.say_hello()
Pluto says woof
>>> dog.save()

>>> cat = Cat(name='Felix')
>>> cat.say_hello()
Felix says meaow
>>> cat.save()
>>> cat.name = 'Garfield'
>>> cat.save(force_update=True)
>>> cat.say_hello()
Garfield says meaow
"""}
