"""Testing a problem with db/backends/postgresql/operations.py: sequence_reset_sql
That method gets called at the end of a loaddata and this part is a problem:

    for f in model._meta.many_to_many:
        output.append("%s setval('%s', coalesce(max(%s), 1), max(%s) %s null) %s %s;" % \
            (style.SQL_KEYWORD('SELECT'),
            style.SQL_FIELD(qn('%s_id_seq' % f.m2m_db_table())),
            style.SQL_FIELD(qn('id')),
            style.SQL_FIELD(qn('id')),
            style.SQL_KEYWORD('IS NOT'),
            style.SQL_KEYWORD('FROM'),
            style.SQL_TABLE(qn(f.m2m_db_table()))))

If you have models with a M2M through that doesn't use integer
PK this code is still executed and that is an error.

The following is self-contained, except that it uses the UUIDField from the
django_extensions project.

I added 1 Book and 3 Authors and set-up the M2M relationship
between them.  Then I issued the following commands:

$ python manage.py dumpdata --format=json --indent=4 srtest > srtest_dump.json
$ python manage.py reset srtest
$ python manage.py loaddata srtest_dump.json

Here is the output from the loaddata command:

Installing json fixture 'srtest_dump' from absolute path.
Traceback (most recent call last):
  File "manage.py", line 11, in <module>
    execute_manager(settings)
  File "/usr/local/lib/python2.5/site-packages/django/core/management/__init__.py", line 359, in execute_manager
    utility.execute()
  File "/usr/local/lib/python2.5/site-packages/django/core/management/__init__.py", line 304, in execute
    self.fetch_command(subcommand).run_from_argv(self.argv)
  File "/usr/local/lib/python2.5/site-packages/django/core/management/base.py", line 195, in run_from_argv
    self.execute(*args, **options.__dict__)
  File "/usr/local/lib/python2.5/site-packages/django/core/management/base.py", line 222, in execute
    output = self.handle(*args, **options)
  File "/usr/local/lib/python2.5/site-packages/django/core/management/commands/loaddata.py", line 196, in handle
    cursor.execute(line)
  File "/usr/local/lib/python2.5/site-packages/django/db/backends/util.py", line 19, in execute
    return self.cursor.execute(sql, params)
psycopg2.ProgrammingError: COALESCE types text and integer cannot be matched

This was tested with Django revision 10604
"""
from django.contrib import admin
from django.db import models
from django_extensions.db.fields import UUIDField

class Author(models.Model):
    id = UUIDField(primary_key=True)
    name = models.CharField(max_length=64)
    def __unicode__(self):
        return self.name

class Book(models.Model):
    id = UUIDField(primary_key=True)
    title = models.CharField(max_length=64)
    authors = models.ManyToManyField(Author, through='BookAuthors')
    def __unicode__(self):
        return self.title

class BookAuthors(models.Model):
    id = UUIDField(primary_key=True)
    author = models.ForeignKey(Author)
    book = models.ForeignKey(Book)
    def __unicode__(self):
        return "%s - %s" % (self.author, self.book)


class AuthorAdmin(admin.ModelAdmin):
    pass
admin.site.register(Author, AuthorAdmin)

class BookAdmin(admin.ModelAdmin):
    pass
admin.site.register(Book, BookAdmin)

class BookAuthorsAdmin(admin.ModelAdmin):
    pass
admin.site.register(BookAuthors, BookAuthorsAdmin)
