"""
This file demonstrates writing tests using the unittest module. These will pass
when you run "manage.py test".

Replace this with more appropriate tests for your application.
"""

from django.test import TestCase

import threading
import time
from django.db import connection, connections


def wait_and_check(conn):
    time.sleep(10)
    cursor = conn.cursor()
    cursor.execute("select datname from pg_stat_activity where procpid = pg_backend_pid()")
    print cursor.fetchone()[0]

def wait_and_check_shared(conn):
    # different method so that stack trace shows us where we are...
    wait_and_check(conn)

def open_wait_and_check(conn):
    cursor = conn.cursor()
    cursor.execute("select 1")
    print cursor.fetchone()[0]
    wait_and_check(conn)

class SimpleTest(TestCase):
    def test_new_conn(self):
        t = threading.Thread(target=wait_and_check,
                             args=(connection,))
        t.start()

    def test_share_conn(self):
        connections['default'].allow_thread_sharing = True
        t = threading.Thread(target=wait_and_check_shared,
                             args=(connections['default'],))
        t.start()
    
    """ Disabled by default - prevents dropping the test database
    def test_open_conn(self):
        t = threading.Thread(target=open_wait_and_check,
                             args=(connection,))
        t.start()
    """
