from datetime import datetime

import pytz

from django.db import models

class SomeClass(models.Model):
    name = models.CharField(max_length=1024, default='', blank=True)
    added = models.DateTimeField()
    changed = models.DateTimeField()
        
    def save(self, force_insert=False, force_update=False):
        if not self.id:
            self.added = self.changed = datetime.now()
            
        else:
            self.changed = datetime.now()
            
        super(SomeClass, self).save(force_insert=force_insert, force_update=force_update)

class SomeClassTZ(models.Model):
    name = models.CharField(max_length=1024, default='', blank=True)
    added = models.DateTimeField()
    changed = models.DateTimeField()
        
    def save(self, force_insert=False, force_update=False):
        if not self.id:
            self.added = self.changed = datetime.now(tz=pytz.utc)
            
        else:
            self.changed = datetime.now(tz=pytz.utc)
            
        super(SomeClassTZ, self).save(force_insert=force_insert, force_update=force_update)




