# Example email backend implementation for App Engine.
# Most of this code is taken from here:
# http://code.google.com/p/google-app-engine-django/source/browse/trunk/appengine_django/mail.py

import logging

from django.core.mail.backends.base import BaseEmailBackend
from django.core.mail import EmailMultiAlternatives
from django.core.exceptions import ImproperlyConfigured

try:
    from google.appengine.api import mail as gaemail
except ImportError, err:
    raise ImproperlyConfigured(('Failed to import App Engine libraries: %s'
                                % err))


class AppEngineEmailBackend(BaseEmailBackend):

    def send_messages(self, email_messages):
        num_sent = 0
        for message in email_messages:
            if self._send(message):
                num_sent += 1
        return num_sent

    def _copy_message(self, message):
        """Create and return App Engine EmailMessage class from message."""
        gmsg = gaemail.EmailMessage(sender=message.from_email,
                                    to=message.to,
                                    subject=message.subject,
                                    body=message.body)
        if message.extra_headers.get('Reply-To', None):
            gmsg.reply_to = message.extra_headers['Reply-To']
        if message.bcc:
            gmsg.bcc = list(message.bcc)
        if message.attachments:
            gmsg.attachments = [(a[0], a[1]) for a in message.attachments]
        if isinstance(message, EmailMultiAlternatives):  # look for HTML
            for content, mimetype in message.alternatives:
                if mimetype == 'text/html':
                    gmsg.html = content
                    break
        return gmsg

    def _send(self, message):
        try:
            msg = self._copy_message(message)
        except (ValueError, AttributeError, gaemail.Error):
            # e.g. a empty body raises ValueError
            if not self.fail_silently:
                raise
            return False
        try:
            msg.send()
        except gaemail.Error:
            if not self.fail_silently:
                raise
            return False
        return True
