from django.db import models

class MyModel( models.Model ):
    """
    Test ModelFormSet.save(commit=False) delete behavior

    >>> from apps.modelformset_regress.models import MyModel
    >>> MyModel(name='Foobar').save()
    >>> MyModel.objects.all()
    [<MyModel: Foobar>]
    >>> from django.forms.models import modelformset_factory
    >>> MyFormSet = modelformset_factory(MyModel, can_delete=True)
    >>> formset = MyFormSet({
    ... 'form-TOTAL_FORMS':'2',
    ... 'form-INITIAL_FORMS':'1',
    ... 'form-MAX_NUM_FORMS':'',
    ... 'form-0-name':'Foobar',
    ... 'form-0-DELETE':'1',
    ... 'form-0-id':'1',
    ... })
    >>> formset.is_valid()
    True
    >>> formset.save(commit=False)
    []
    >>> MyModel.objects.all()
    [<MyModel: Foobar>]
    """
    name = models.CharField(max_length=20)

    def __unicode__( self ):
        return u'%s' % self.name

