from django.db import models

class ModelA(models.Model):
    name = models.CharField(max_length=100)

    def __unicode__(self):
        return self.name

class ModelB(models.Model):
    name = models.CharField(max_length=100)
    somebool = models.BooleanField(default=True)
    a = models.ForeignKey(ModelA)

    def __unicode__(self):
        return self.name

from django.db.models.aggregates import Count
__test__ = {"doctest": """
>>> a = ModelA.objects.create(name="testA")
>>> b1 = ModelB.objects.create(name="B1", a=a, somebool=True)
>>> b2 = ModelB.objects.create(name="B2", a=a, somebool=True)
>>> ModelA.objects.all().annotate(num_b=Count('modelb')).filter(modelb__somebool=True)[0].num_b
2
"""}
